(function(){
	function post(action, data) {
		data = data || {};
		data.action = action;
		data.nonce = FLW_SU.nonce;
		return fetch(FLW_SU.ajax_url, {
			method: 'POST',
			headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
			body: new URLSearchParams(data).toString()
		}).then(function(r){ return r.json(); });
	}
	function showNotice(type, text){
		var box = document.getElementById('flw-su-notice');
		if (!box) return;
		var cls = type === 'error' ? 'notice notice-error' : 'notice notice-success';
		box.innerHTML = '<div class="'+cls+'"><p>'+text+'</p></div>';
	}
	function byId(id){ return document.getElementById(id); }
	function setText(id, text){ var el = byId(id); if (el) el.textContent = text; }
	function setValue(id, val){ var el = byId(id); if (el) el.value = val; }

	document.addEventListener('DOMContentLoaded', function(){
		var btnOpenModal = byId('flw-su-open-modal');
		var modal = byId('flw-su-login-modal');
		var btnLoginSubmit = byId('flw-su-login-submit');
		var btnLoginCancel = byId('flw-su-login-cancel');
		var btnPortal = byId('flw-su-portal');
		if (btnOpenModal && modal) {
			btnOpenModal.addEventListener('click', function(){ modal.style.display = 'block'; });
		}
		if (btnLoginCancel && modal) {
			btnLoginCancel.addEventListener('click', function(){ modal.style.display = 'none'; });
		}
		function refreshStatusAndUI(silent){
			if (typeof silent === 'undefined') silent = true;
			return post('flw_su_status', {}).then(function(res){
				if (res && res.success) {
					var st = res.data.status || 'unknown';
					setText('flw-su-status', st);
					if (btnOpenModal) { btnOpenModal.style.display = (st === 'authorized') ? 'none' : ''; }
					if (btnPortal) { btnPortal.disabled = !(res.data && res.data.has_customer); }
					if (!silent) { showNotice('success', 'Status refreshed.'); }
				} else {
					if (!silent) { showNotice('error', 'Status refresh failed.'); }
				}
			}).catch(function(){
				if (!silent) { showNotice('error', 'Status refresh failed.'); }
			});
		}
		if (btnLoginSubmit && modal) {
			btnLoginSubmit.addEventListener('click', function(){
				var user = byId('flw-su-login-user').value || '';
				var pass = byId('flw-su-login-pass').value || '';
				if (!user || !pass) { showNotice('error', 'Username and password required'); return; }
				var broker = btnLoginSubmit.getAttribute('data-broker');
				btnLoginSubmit.disabled = true;
				fetch(broker + '/wp-json/flw_su/v1/auth/login', {
					method: 'POST',
					headers: { 'Content-Type': 'application/json' },
					body: JSON.stringify({ username: user, password: pass })
				}).then(function(r){ return r.json(); })
				.then(function(res){
					if (res && res.code) {
						post('flw_su_exchange_code', { code: res.code })
							.then(function(ex){
								if (ex.success) {
									setValue('flw-su-client-id', ex.data.client_id || '');
									setText('flw-su-status', 'authorized');
									showNotice('success', 'Registration successful.');
									if (btnOpenModal) btnOpenModal.style.display = 'none';
									if (modal) modal.style.display = 'none';
									refreshStatusAndUI(true);
								} else {
									showNotice('error', 'Exchange failed: ' + (ex.data && ex.data.message ? ex.data.message : 'Unknown error'));
								}
							});
					} else {
						showNotice('error', 'Sign-in failed');
					}
				})
				.finally(function(){ btnLoginSubmit.disabled = false; });
			});
		}
		refreshStatusAndUI(true);
		if (btnPortal) {
			btnPortal.addEventListener('click', function(){
				post('flw_su_billing_portal', {})
					.then(function(res){
						if (res.success && res.data.url) { window.open(res.data.url, '_blank'); }
						else { alert('Portal failed.'); }
					});
			});
		}
		var btnReg = byId('flw-su-register');
		var btnClear = byId('flw-su-clear');
		var btnRefresh = byId('flw-su-refresh');
		var btnExample = byId('flw-su-example');
		var btnExchange = byId('flw-su-exchange-code');
		if (btnReg) {
			btnReg.addEventListener('click', function(){
				btnReg.disabled = true;
				post('flw_su_register_site', {})
					.then(function(res){
						if (res.success) {
							setValue('flw-su-client-id', res.data.client_id);
							setText('flw-su-status', 'authorized');
							document.getElementById('flw-su-refresh').disabled = false;
							document.getElementById('flw-su-portal').disabled = false;
							if (document.getElementById('flw-su-example')) document.getElementById('flw-su-example').disabled = false;
							showNotice('success', 'Registered successfully.');
						} else {
							showNotice('error', 'Registration failed: ' + (res.data && res.data.message ? res.data.message : 'Unknown error'));
						}
					})
					.finally(function(){ btnReg.disabled = false; });
			});
		}
		if (btnRefresh) {
			btnRefresh.addEventListener('click', function(){
				var originalText = btnRefresh.textContent;
				btnRefresh.disabled = true;
				btnRefresh.textContent = 'Refreshing...';
				setText('flw-su-status', 'Checking...');
				refreshStatusAndUI(false)
					.finally(function(){
						btnRefresh.disabled = false;
						btnRefresh.textContent = originalText;
					});
			});
		}
		if (btnExample) {
			btnExample.addEventListener('click', function(){
				btnExample.disabled = true;
				post('flw_su_product_example', {})
					.then(function(res){
						if (res.success) {
							var msg = (res.data && res.data.message) ? res.data.message : 'Example action executed.';
							showNotice('success', msg);
						} else {
							showNotice('error', 'Example action failed: ' + (res.data && res.data.message ? res.data.message : 'Unknown error'));
						}
					})
					.finally(function(){ btnExample.disabled = false; });
			});
		}
		if (btnExchange) {
			btnExchange.addEventListener('click', function(e){
				e.preventDefault();
				var code = (byId('flw-su-reg-code') && byId('flw-su-reg-code').value) || '';
				if (!code) { showNotice('error', 'Please enter your registration code.'); return; }
				btnExchange.disabled = true;
				post('flw_su_exchange_code', { code: code })
					.then(function(res){
						if (res.success) {
							setValue('flw-su-client-id', res.data.client_id || '');
							setText('flw-su-status', 'authorized');
							showNotice('success', 'Registration successful.');
							refreshStatusAndUI(true);
						} else {
							showNotice('error', 'Exchange failed: ' + (res.data && res.data.message ? res.data.message : 'Unknown error'));
						}
					})
					.finally(function(){ btnExchange.disabled = false; });
			});
		}
		// Subscribe to a specific plan via Subscriptions tab
		document.body.addEventListener('click', function(e){
			var target = e.target;
			if (target && target.classList && target.classList.contains('flw-su-subscribe-plan')) {
				e.preventDefault();
				var planKey = target.getAttribute('data-plan-key') || '';
				target.disabled = true;
				var returnUrl = window.location.href;
				post('flw_su_checkout_session', { plan_key: planKey, return_url: returnUrl })
					.then(function(res){
						if (res.success && res.data.url) {
							window.open(res.data.url, '_blank');
						} else {
							var msg = (res && res.data && res.data.message) ? res.data.message : 'Checkout session failed.';
							alert(msg);
						}
					})
					.finally(function(){ target.disabled = false; });
			}

			// Dashboard: click Update Available
			if (target && target.classList && target.classList.contains('flw-su-run-update')) {
				e.preventDefault();
				var pluginFile = target.getAttribute('data-plugin') || '';
				if (!pluginFile) return;
				var isSelf = target.getAttribute('data-self') === '1';
				var selfUrl = target.getAttribute('data-update-url') || '';
				var entitled = target.getAttribute('data-entitled') === '1';
				if (!entitled && !isSelf) {
					var manual = document.getElementById('flw-su-manual-modal');
					if (manual) manual.style.display = 'block';
					return;
				}
				target.textContent = 'Updating...';
				target.style.pointerEvents = 'none';
				if (isSelf && selfUrl) {
					// For self-update, redirect to core upgrader screen to avoid breaking the running code
					window.location.href = selfUrl;
					return;
				}
				post('flw_su_run_update', { plugin: pluginFile })
					.then(function(res){
						if (res.success) {
							showNotice('success', 'Update completed. Reloading...');
							setTimeout(function(){ window.location.reload(); }, 1200);
						} else {
							var code = (res && res.data && res.data.status) ? res.data.status : 0;
							if (code === 402) {
								var modal = document.getElementById('flw-su-subscribe-modal');
								if (modal) modal.style.display = 'block';
								showNotice('error', 'Subscription required to run updates.');
							} else {
								var msg = (res && res.data && res.data.message) ? res.data.message : 'Update failed.';
								showNotice('error', msg);
							}
						}
					})
					.finally(function(){
						target.textContent = 'Update Available';
						target.style.pointerEvents = '';
					});
			}
		});
		// Close subscribe modal
		var subClose = document.getElementById('flw-su-subscribe-close');
		if (subClose) {
			subClose.addEventListener('click', function(){
				var m = document.getElementById('flw-su-subscribe-modal');
				if (m) m.style.display = 'none';
			});
		}
		// Close manual modal
		var manualClose = document.getElementById('flw-su-manual-close');
		if (manualClose) {
			manualClose.addEventListener('click', function(){
				var mm = document.getElementById('flw-su-manual-modal');
				if (mm) mm.style.display = 'none';
			});
		}
		if (btnClear) {
			btnClear.addEventListener('click', function(){
				var confirmed = window.confirm('This will remove this site\'s registration and revoke access. You may lose update access until you re-register. Continue?');
				if (!confirmed) { return; }
				post('flw_su_clear_registration', {})
					.then(function(res){
						if (res.success) {
							setValue('flw-su-client-id', '');
							setText('flw-su-status', 'unregistered');
							if (byId('flw-su-refresh')) byId('flw-su-refresh').disabled = true;
							if (byId('flw-su-portal')) byId('flw-su-portal').disabled = true;
							if (btnOpenModal) btnOpenModal.style.display = '';
							if (byId('flw-su-example')) byId('flw-su-example').disabled = true;
							showNotice('success', 'Registration cleared and client revoked.');
						} else {
							showNotice('error', 'Clear failed: ' + (res.data && res.data.message ? res.data.message : 'Unknown error'));
						}
					});
			});
		}
	});
})();