<?php
if (!defined('ABSPATH')) { exit; }

if (!function_exists('flw_su_render_dashboard_page')) {
	function flw_su_render_dashboard_page() {
		if (!current_user_can('manage_options')) { return; }
		if (!function_exists('get_plugins')) {
			require_once ABSPATH . 'wp-admin/includes/plugin.php';
		}
		$all_plugins = get_plugins();
		$authors = [ 'FrontLine Works', 'FrostLine Works', 'Tyson Brooks' ];
		$matches_author = function(string $authorHtml) use ($authors): bool {
			$author = trim(wp_strip_all_tags($authorHtml));
			foreach ($authors as $needle) {
				if ($needle !== '' && stripos($author, $needle) !== false) { return true; }
			}
			return false;
		};
		$plugins = [];
		$updates_map = function_exists('flw_su_get_update_map') ? flw_su_get_update_map() : [];
		$self_basename = plugin_basename(dirname(__DIR__, 2) . '/local.php');
		$entitled = function_exists('flw_su_is_entitled_for_updates') ? (bool) flw_su_is_entitled_for_updates() : false;
		foreach ($all_plugins as $file => $data) {
			if (!$matches_author((string)($data['Author'] ?? ''))) { continue; }
			$plugins[] = [
				'file' => $file,
				'name' => (string)($data['Name'] ?? $file),
				'version' => (string)($data['Version'] ?? ''),
				'active' => is_plugin_active($file),
				'has_update' => !empty($updates_map[$file]),
				'raw' => $data,
			];
		}
		usort($plugins, function($a, $b){ return strcasecmp($a['name'], $b['name']); });
		$broker = defined('FLW_SU_BROKER_BASE') ? FLW_SU_BROKER_BASE : get_option(FLW_SU_OPTION_BROKER_URL, '');
		?>
		<div class="wrap">
			<h1><?php echo esc_html__('Secure Updates — Dashboard', 'flw-secure-updates-local'); ?></h1>
			<?php if (!$entitled): ?>
				<div class="flw-su-hero" style="margin:14px 0 18px; padding:24px; border:3px solid #d63638; border-radius:10px; background:linear-gradient(135deg,#fff2f2 0%, #fff9f9 60%, #ffffff 100%);">
					<div style="display:flex; align-items:flex-start; gap:24px;">
						<div style="flex:1; min-width:0;">
							<h2 style="margin:0 0 8px; font-size:22px; line-height:1.25; color:#1d2327;">
								<?php echo esc_html__('Unlock One‑Click Auto‑Updates for FLW Plugins', 'flw-secure-updates-local'); ?>
							</h2>
							<p style="margin:0 0 10px; font-size:14px; color:#2c3338;">
								<?php echo esc_html__('Stop downloading zips. A subscription enables seamless updates across all FrostLine Works & Tyson Brooks plugins on this site.', 'flw-secure-updates-local'); ?>
							</p>
							<ul style="margin:0 0 14px 18px; padding:0; list-style:disc; color:#2c3338;">
								<li><?php echo esc_html__('One‑click updates from the Plugins screen', 'flw-secure-updates-local'); ?></li>
								<li><?php echo esc_html__('No manual downloads or file uploads', 'flw-secure-updates-local'); ?></li>
								<li><?php echo esc_html__('Priority access to new features and fixes', 'flw-secure-updates-local'); ?></li>
							</ul>
							<a href="<?php echo esc_url(admin_url('admin.php?page=flw_su_settings&tab=subscriptions')); ?>" class="button button-primary" style="height:auto; padding:8px 14px; font-weight:600;">
								<?php echo esc_html__('View Plans & Subscribe', 'flw-secure-updates-local'); ?>
							</a>
						</div>
						<div style="flex:0 0 220px; text-align:center;">
							<div style="display:inline-block; padding:10px 14px; border:2px dashed #d63638; border-radius:8px; background:#fff; color:#d63638; font-weight:700;">
								<?php echo esc_html__('Save time every update', 'flw-secure-updates-local'); ?>
							</div>
						</div>
					</div>
				</div>
			<?php endif; ?>
			<div id="flw-su-notice" style="margin-top:10px;"></div>
			<p><?php echo esc_html__('Manage FLW/Tyson Brooks plugins from one place.', 'flw-secure-updates-local'); ?></p>
			<style>
				/* FLW: stronger zebra striping for dashboard table */
				table.widefat.flw-su-zebra tbody tr:nth-child(odd) { background-color: #ffffff; }
				table.widefat.flw-su-zebra tbody tr:nth-child(even) { background-color: #eef1f5; }
			</style>
			<table class="widefat striped flw-su-zebra">
				<thead>
				<tr>
					<th style="width:52px;">&nbsp;</th>
					<th><?php echo esc_html__('Plugin Name', 'flw-secure-updates-local'); ?></th>
					<th style="width:120px;">&nbsp;<?php echo esc_html__('Version', 'flw-secure-updates-local'); ?></th>
					<th style="width:160px;">&nbsp;<?php echo esc_html__('Update Status', 'flw-secure-updates-local'); ?></th>
					<th style="width:260px;">&nbsp;<?php echo esc_html__('Actions', 'flw-secure-updates-local'); ?></th>
				</tr>
				</thead>
				<tbody>
				<?php if (empty($plugins)) : ?>
					<tr><td colspan="5"><?php echo esc_html__('No matching plugins found.', 'flw-secure-updates-local'); ?></td></tr>
				<?php else: foreach ($plugins as $p): $file = $p['file']; $data = $p['raw']; ?>
					<tr>
						<td><?php
							$plugin_dir = WP_PLUGIN_DIR . '/' . dirname($file);
							$logo_path = $plugin_dir . '/assets/logo-128x128.png';
							$logo_url = '';
							if (file_exists($logo_path)) {
								$logo_url = plugin_dir_url(WP_PLUGIN_DIR . '/' . $file) . 'assets/logo-128x128.png';
							}
							if ($logo_url === '') {
								$default_id = (int) get_option('flw_plugin_default_thumb_id', 0);
								$logo_url = $default_id ? wp_get_attachment_image_url($default_id, [40,40]) : '';
								if (!$logo_url) { $logo_url = FLW_SU_LOCAL_URL . 'assets/plugin-placeholder.png'; }
							}
							echo '<img src="' . esc_url($logo_url) . '" alt="" style="width:40px;height:40px;object-fit:cover;border-radius:4px;" />';
						?></td>
						<td><?php echo esc_html($p['name']); ?></td>
						<td><?php echo esc_html($p['version']); ?></td>
						<td>
							<?php if ($p['has_update']) : ?>
								<?php if ($file === $self_basename) { $self_update_url = wp_nonce_url(admin_url('update.php?action=upgrade-plugin&plugin=' . urlencode($file)), 'upgrade-plugin_' . $file); } ?>
								<a href="#" class="flw-su-run-update" data-plugin="<?php echo esc_attr($file); ?>" data-entitled="<?php echo $entitled ? '1' : '0'; ?>"<?php if ($file === $self_basename) { echo ' data-self="1" data-update-url="' . esc_url($self_update_url) . '"'; } ?> style="color:#a00;font-weight:700;">
									<?php echo esc_html__('Update Available', 'flw-secure-updates-local'); ?>
								</a>
							<?php else: ?>
								<span style="color:#0a0;font-weight:600;">&nbsp;<?php echo esc_html__('Up-to-date', 'flw-secure-updates-local'); ?></span>
							<?php endif; ?>
						</td>
						<td>
							<?php if ($p['active']) : ?>
								<?php
									// Attempt to detect a Settings link registered by the plugin
									$settings_link = '';
									$action_links = apply_filters('plugin_action_links_' . $file, [], $file, $data, 'all');
									if (is_array($action_links)) {
										foreach ($action_links as $al) {
											if (stripos(wp_strip_all_tags($al), 'settings') !== false) { $settings_link = $al; break; }
										}
									}
									if ($settings_link !== '') { echo $settings_link; echo ' &middot; '; }
									$deactivate_url = wp_nonce_url(admin_url('plugins.php?action=deactivate&plugin=' . urlencode($file)), 'deactivate-plugin_' . $file);
									?>
									<a href="<?php echo esc_url($deactivate_url); ?>"><?php echo esc_html__('Deactivate', 'flw-secure-updates-local'); ?></a>
							<?php else: ?>
								<?php $activate_url = wp_nonce_url(admin_url('plugins.php?action=activate&plugin=' . urlencode($file)), 'activate-plugin_' . $file); ?>
								<a href="<?php echo esc_url($activate_url); ?>"><?php echo esc_html__('Activate', 'flw-secure-updates-local'); ?></a>
							<?php endif; ?>
						</td>
					</tr>
				<?php endforeach; endif; ?>
				</tbody>
			</table>

			<?php if (function_exists('flw_su_render_modal_markup')) { flw_su_render_modal_markup($broker); } ?>
			<div id="flw-su-subscribe-modal" style="display:none;position:fixed;left:0;top:0;width:100%;height:100%;background:rgba(0,0,0,.4);z-index:9999;">
				<div style="background:#fff;max-width:480px;margin:10% auto;padding:20px;border-radius:6px;">
					<h3><?php echo esc_html__('Subscribe to Enable Auto-Updates', 'flw-secure-updates-local'); ?></h3>
					<p class="description"><?php echo esc_html__('A paid subscription is required to run updates from this dashboard.', 'flw-secure-updates-local'); ?></p>
					<p>
						<a class="button button-primary" href="<?php echo esc_url(admin_url('admin.php?page=flw_su_settings&tab=subscriptions')); ?>"><?php echo esc_html__('View Plans', 'flw-secure-updates-local'); ?></a>
						<button class="button" id="flw-su-subscribe-close"><?php echo esc_html__('Close', 'flw-secure-updates-local'); ?></button>
					</p>
				</div>
			</div>
			<div id="flw-su-manual-modal" style="display:none;position:fixed;left:0;top:0;width:100%;height:100%;background:rgba(0,0,0,.4);z-index:9999;">
				<div style="background:#fff;max-width:520px;margin:10% auto;padding:20px;border-radius:6px;">
					<h3><?php echo esc_html__('Manual Update Required', 'flw-secure-updates-local'); ?></h3>
					<p class="description"><?php echo esc_html__("An update is available for this plugin. To install it without a subscription, you'll need to visit FrostLine Works to download it manually.", 'flw-secure-updates-local'); ?></p>
					<p><button class="button" id="flw-su-manual-close"><?php echo esc_html__('Close', 'flw-secure-updates-local'); ?></button></p>
				</div>
			</div>
		</div>
		<?php
	}
}

