<?php
if (!defined('ABSPATH')) {
	exit;
}

function flw_su_hmac_sign(string $method, string $route_path, array $body): array {
	$client_id = get_option(FLW_SU_OPTION_CLIENT_ID, '');
	$client_secret = get_option(FLW_SU_OPTION_CLIENT_SECRET, '');
	$timestamp = (string) time();
	$nonce = wp_generate_password(24, false, false);
	$upper = strtoupper($method);
	$body_json = ($upper === 'GET') ? '' : wp_json_encode($body ?? []);
	$body_hash = hash('sha256', $body_json);
	$payload = $upper . "\n" . $route_path . "\n" . $timestamp . "\n" . $nonce . "\n" . $body_hash;
	$signature = base64_encode(hash_hmac('sha256', $payload, $client_secret, true));
	$headers = [
		'x-flw-su-key' => $client_id,
		'x-flw-su-timestamp' => $timestamp,
		'x-flw-su-nonce' => $nonce,
		'x-flw-su-signature' => $signature,
	];
	if ($upper !== 'GET') {
		$headers['Content-Type'] = 'application/json';
	}
	return [
		'headers' => $headers,
		'body' => $body_json,
	];
}