<?php
if (!defined('ABSPATH')) { exit; }

require_once __DIR__ . '/hmac-signer.php';

/**
 * Perform an HMAC-signed request to the Remote broker.
 * @param string $method HTTP method
 * @param string $route_path Route path starting with /flw_su/v1/...
 * @param array $body Associative array body
 * @return array|WP_Error { code:int, body:string, json:mixed }
 */
function flw_su_remote_request(string $method, string $route_path, array $body = []) {
	$broker = defined('FLW_SU_BROKER_BASE') ? FLW_SU_BROKER_BASE : get_option(FLW_SU_OPTION_BROKER_URL, '');
	$sign = flw_su_hmac_sign($method, $route_path, $body);
	$url = rtrim($broker, '/') . '/wp-json' . $route_path;
	$args = [
		'method' => strtoupper($method),
		'headers' => $sign['headers'],
		'timeout' => 15,
	];
	if (strtoupper($method) !== 'GET') {
		$args['body'] = $sign['body'];
	}
	$response = wp_remote_request($url, $args);
	if (is_wp_error($response)) {
		return $response;
	}
	$code = (int) wp_remote_retrieve_response_code($response);
	$body_str = (string) wp_remote_retrieve_body($response);
	$json = json_decode($body_str, true);
	return [ 'code' => $code, 'body' => $body_str, 'json' => $json ];
}