<?php
if (!defined('ABSPATH')) {
	exit;
}

function flw_su_render_local_tabs_nav(string $active) {
	$tabs = [
		'general' => __('General', 'flw-secure-updates-local'),
		'subscriptions' => __('Subscriptions', 'flw-secure-updates-local'),
		'instructions' => __('Instructions', 'flw-secure-updates-local'),
		'help' => __('Help', 'flw-secure-updates-local'),
	];
	echo '<h2 class="nav-tab-wrapper">';
	foreach ($tabs as $slug => $label) {
		$url = admin_url('admin.php?page=flw_su_settings&tab=' . $slug);
		$cls = 'nav-tab' . ($active === $slug ? ' nav-tab-active' : '');
		echo '<a class="' . esc_attr($cls) . '" href="' . esc_url($url) . '">' . esc_html($label) . '</a>';
	}
	echo '</h2>';
}

function flw_su_render_modal_markup(string $broker) {
	?>
	<div id="flw-su-login-modal" style="display:none;position:fixed;left:0;top:0;width:100%;height:100%;background:rgba(0,0,0,.4);z-index:9999;">
		<div style="background:#fff;max-width:420px;margin:10% auto;padding:20px;border-radius:6px;">
			<h3><?php echo esc_html__('Sign in to FLW', 'flw-secure-updates-local'); ?></h3>
			<p class="description"><?php echo esc_html__('Use your Frostline Works account to generate a registration code.', 'flw-secure-updates-local'); ?></p>
			<p><label><?php echo esc_html__('Username', 'flw-secure-updates-local'); ?><br><input type="text" id="flw-su-login-user" class="regular-text" /></label></p>
			<p><label><?php echo esc_html__('Password', 'flw-secure-updates-local'); ?><br><input type="password" id="flw-su-login-pass" class="regular-text" /></label></p>
			<p>
				<button class="button button-primary" id="flw-su-login-submit" data-broker="<?php echo esc_attr(rtrim($broker,'/')); ?>"><?php echo esc_html__('Sign in', 'flw-secure-updates-local'); ?></button>
				<button class="button" id="flw-su-login-cancel"><?php echo esc_html__('Cancel', 'flw-secure-updates-local'); ?></button>
				<a class="button-link" target="_blank" href="<?php echo esc_url(rtrim($broker,'/')); ?>/wp-login.php?action=register"><?php echo esc_html__('Create account', 'flw-secure-updates-local'); ?></a>
			</p>
		</div>
	</div>
	<?php
}

function flw_su_render_general_tab(string $client_id, string $broker, bool $registered, string $status) {
	$active_tab = isset($_GET['tab']) ? sanitize_key($_GET['tab']) : 'general';
	$return_to = admin_url('admin.php?page=flw_su_settings&tab=' . $active_tab);
	?>
	<p><?php echo esc_html__('Register this site with the broker and manage your subscription.', 'flw-secure-updates-local'); ?></p>
	<form method="post" action="options.php">
		<?php settings_fields('flw_su_local'); ?>
		<table class="form-table" role="presentation">
			<tbody>
				<tr>
					<th scope="row"><?php echo esc_html__('Broker Base URL', 'flw-secure-updates-local'); ?></th>
					<td><input type="url" name="<?php echo esc_attr(FLW_SU_OPTION_BROKER_URL); ?>" value="<?php echo esc_attr($broker); ?>" class="regular-text" readonly /></td>
				</tr>
				<tr>
					<th scope="row"><?php echo esc_html__('Client ID', 'flw-secure-updates-local'); ?></th>
					<td><input type="text" id="flw-su-client-id" readonly value="<?php echo esc_attr($client_id); ?>" class="regular-text" /></td>
				</tr>
				<tr>
					<th scope="row"><?php echo esc_html__('Status', 'flw-secure-updates-local'); ?></th>
					<td>
						<span id="flw-su-status"><?php echo esc_html($status); ?></span>
						<p class="description" style="margin-top:6px;">
							<strong><?php echo esc_html__('What the status means:', 'flw-secure-updates-local'); ?></strong><br />
							<strong><?php echo esc_html__('Authorized', 'flw-secure-updates-local'); ?></strong>: <?php echo esc_html__('This site is registered and has an active subscription (or is exempt).', 'flw-secure-updates-local'); ?><br />
							<strong><?php echo esc_html__('Unauthorized', 'flw-secure-updates-local'); ?></strong>: <?php echo esc_html__('Registered, but no active subscription. Subscribe or update billing via “Manage Subscription”.', 'flw-secure-updates-local'); ?><br />
							<strong><?php echo esc_html__('Unregistered', 'flw-secure-updates-local'); ?></strong>: <?php echo esc_html__('Not linked to the broker yet. Sign in and exchange a registration code to register.', 'flw-secure-updates-local'); ?><br />
							<strong><?php echo esc_html__('Unknown', 'flw-secure-updates-local'); ?></strong>: <?php echo esc_html__('Could not reach the broker. Click “Refresh Status” or verify your Broker URL and connectivity.', 'flw-secure-updates-local'); ?>
						</p>
					</td>
				</tr>
				<?php if (!$registered) : ?>
				<tr>
					<th scope="row"><?php echo esc_html__('Registration Code', 'flw-secure-updates-local'); ?></th>
					<td>
						<input type="text" id="flw-su-reg-code" class="regular-text" placeholder="Enter code from broker" />
						<button class="button" id="flw-su-exchange-code" <?php echo $registered ? 'disabled' : ''; ?>><?php echo esc_html__('Exchange Code', 'flw-secure-updates-local'); ?></button>
						<p class="description"><?php echo esc_html__('Sign in using the modal to generate a code automatically.', 'flw-secure-updates-local'); ?></p>
					</td>
				</tr>
				<?php endif; ?>
			</tbody>
		</table>
		<?php submit_button(); ?>
	</form>
	<p>
		<?php if (!$registered): ?>
		<button class="button button-primary" id="flw-su-open-modal"><?php echo esc_html__('Sign in with FLW', 'flw-secure-updates-local'); ?></button>
		<?php endif; ?>
		<button class="button" id="flw-su-refresh" <?php echo $registered ? '' : 'disabled'; ?>><?php echo esc_html__('Refresh Status', 'flw-secure-updates-local'); ?></button>
		<?php
		// Manage Subscription disabled until a subscription exists; enable via JS after status check if needed
		$portal_disabled = 'disabled';
		?>
		<button class="button" id="flw-su-portal" <?php echo $portal_disabled; ?>><?php echo esc_html__('Manage Subscription', 'flw-secure-updates-local'); ?></button>
		<button class="button" id="flw-su-example" <?php echo $registered ? '' : 'disabled'; ?>><?php echo esc_html__('Run Example Action', 'flw-secure-updates-local'); ?></button>
		<button class="button" id="flw-su-clear"><?php echo esc_html__('Clear Registration', 'flw-secure-updates-local'); ?></button>
	</p>
	<?php flw_su_render_modal_markup($broker); ?>
	<?php
}

function flw_su_render_subscriptions_tab(bool $registered) {
	if (!$registered) {
		echo '<p>' . esc_html__('Register first to subscribe.', 'flw-secure-updates-local') . '</p>';
		return;
	}
	// Fetch subscription status from Remote for dashboard
	$statusResp = flw_su_remote_request('GET', '/flw_su/v1/subscriptions/status');
	$sub = [
		'authorized' => false,
		'status' => '',
		'plan_key' => '',
		'current_period_end' => null,
		'has_customer' => false,
		'exempt' => false,
	];
	if (!is_wp_error($statusResp) && (int)($statusResp['code'] ?? 500) === 200 && is_array($statusResp['json'])) {
		$sub['authorized'] = !empty($statusResp['json']['authorized']);
		$sub['status'] = is_string($statusResp['json']['status'] ?? '') ? $statusResp['json']['status'] : '';
		$sub['plan_key'] = is_string($statusResp['json']['plan_key'] ?? '') ? $statusResp['json']['plan_key'] : '';
		$sub['current_period_end'] = $statusResp['json']['current_period_end'] ?? null;
		$sub['has_customer'] = !empty($statusResp['json']['has_customer']);
		$sub['exempt'] = !empty($statusResp['json']['exempt']);
	} else {
		echo '<p>' . esc_html__('Unable to load subscription status from broker.', 'flw-secure-updates-local') . '</p>';
	}

	// Render dashboard
	$authText = $sub['authorized'] ? __('Authorized', 'flw-secure-updates-local') : __('Unauthorized', 'flw-secure-updates-local');
	$exemptText = $sub['exempt'] ? __('Yes', 'flw-secure-updates-local') : __('No', 'flw-secure-updates-local');
	$custText = $sub['has_customer'] ? __('Yes', 'flw-secure-updates-local') : __('No', 'flw-secure-updates-local');
	$periodText = $sub['current_period_end'] ? esc_html((string)$sub['current_period_end']) : '—';
	?>
	<h3><?php echo esc_html__('Subscription', 'flw-secure-updates-local'); ?></h3>
	<table class="widefat" style="margin-bottom:12px;">
		<tbody>
			<tr>
				<th style="width:220px;"><?php echo esc_html__('Authorization', 'flw-secure-updates-local'); ?></th>
				<td><?php echo esc_html($authText); ?></td>
			</tr>
			<tr>
				<th><?php echo esc_html__('Exempt', 'flw-secure-updates-local'); ?></th>
				<td><?php echo esc_html($exemptText); ?></td>
			</tr>
			<tr>
				<th><?php echo esc_html__('Plan Key', 'flw-secure-updates-local'); ?></th>
				<td><?php echo $sub['plan_key'] !== '' ? esc_html($sub['plan_key']) : '—'; ?></td>
			</tr>
			<tr>
				<th><?php echo esc_html__('Status', 'flw-secure-updates-local'); ?></th>
				<td><?php echo $sub['status'] !== '' ? esc_html($sub['status']) : '—'; ?></td>
			</tr>
			<tr>
				<th><?php echo esc_html__('Current Period End', 'flw-secure-updates-local'); ?></th>
				<td><?php echo $periodText; ?></td>
			</tr>
			<tr>
				<th><?php echo esc_html__('Stripe Customer Linked', 'flw-secure-updates-local'); ?></th>
				<td><?php echo esc_html($custText); ?></td>
			</tr>
		</tbody>
	</table>
	<?php
	// Fetch plans from Remote
	$result = flw_su_remote_request('GET', '/flw_su/v1/subscriptions/plans');
	if (is_wp_error($result) || (int)($result['code'] ?? 500) !== 200 || empty($result['json']['plans'])) {
		echo '<p>' . esc_html__('Unable to load plans from broker.', 'flw-secure-updates-local') . '</p>';
		$debug = [
			'wp_error' => is_wp_error($result) ? $result->get_error_message() : null,
			'code' => is_array($result) && isset($result['code']) ? (int)$result['code'] : null,
			'body' => is_array($result) && isset($result['body']) ? (string)$result['body'] : null,
		];
		echo '<script>console.error("FLW_SU: plans fetch failed", ' . wp_json_encode($debug) . ');</script>';
		return;
	}
	$plans = $result['json']['plans'];
	echo '<script>console.info("FLW_SU: plans loaded", { count: ' . (int)count($plans) . ', plans: ' . wp_json_encode($plans) . ' });</script>';
	?>
	<h3><?php echo esc_html__('Available Plans', 'flw-secure-updates-local'); ?></h3>
	<table class="widefat">
		<thead><tr><th><?php echo esc_html__('Plan', 'flw-secure-updates-local'); ?></th><th><?php echo esc_html__('Price', 'flw-secure-updates-local'); ?></th><th><?php echo esc_html__('Action', 'flw-secure-updates-local'); ?></th></tr></thead>
		<tbody>
		<?php foreach ($plans as $p): $price = '';
			if (!empty($p['price_amount'])) { $price = '$' . $p['price_amount']; }
			if (!empty($p['price_interval'])) { $price .= '/' . $p['price_interval']; }
		?>
		<tr>
			<td><?php echo esc_html($p['title'] . ' (' . $p['plan_key'] . ')'); ?></td>
			<td><?php echo esc_html($price); ?></td>
			<td><button class="button flw-su-subscribe-plan" data-plan-key="<?php echo esc_attr($p['plan_key']); ?>"><?php echo esc_html__('Subscribe', 'flw-secure-updates-local'); ?></button></td>
		</tr>
		<?php endforeach; ?>
		</tbody>
	</table>
	<?php
}

function flw_su_render_instructions_tab_local() {
	?>
	<h3><?php echo esc_html__('Instructions', 'flw-secure-updates-local'); ?></h3>
	<ol>
		<li><?php echo esc_html__('Set Broker Base URL (pre-filled).', 'flw-secure-updates-local'); ?></li>
		<li><?php echo esc_html__('Click “Register with Broker” to obtain credentials.', 'flw-secure-updates-local'); ?></li>
		<li><?php echo esc_html__('Use the Subscriptions tab to choose a plan and subscribe.', 'flw-secure-updates-local'); ?></li>
		<li><?php echo esc_html__('Manage your subscription via the Manage Subscription button.', 'flw-secure-updates-local'); ?></li>
	</ol>
	<p><?php echo esc_html__('If you encounter issues, check the console logs on the Subscriptions tab and contact support.', 'flw-secure-updates-local'); ?></p>
	<?php
}

function flw_su_render_help_tab() {
	echo '<p>' . esc_html__('Help content coming soon.', 'flw-secure-updates-local') . '</p>';
}

function flw_su_render_settings_page() {
	if (!current_user_can('manage_options')) {
		return;
	}
	$client_id = get_option(FLW_SU_OPTION_CLIENT_ID, '');
	$broker = defined('FLW_SU_BROKER_BASE') ? FLW_SU_BROKER_BASE : get_option(FLW_SU_OPTION_BROKER_URL, '');
	$registered = !empty($client_id);
	$status = $registered ? 'authorized' : 'unregistered';
	$active = isset($_GET['tab']) ? sanitize_key($_GET['tab']) : 'general';
	?>
	<div class="wrap">
		<h1><?php echo esc_html__('FLW Secure Updates', 'flw-secure-updates-local'); ?></h1>
		<div id="flw-su-notice" style="margin-top:10px;"></div>
		<?php flw_su_render_local_tabs_nav($active); ?>
		<div style="margin-top:10px;">
		<?php
			switch ($active) {
				case 'subscriptions':
					flw_su_render_subscriptions_tab($registered);
					break;
				case 'instructions':
					flw_su_render_instructions_tab_local();
					break;
				case 'help':
					flw_su_render_help_tab();
					break;
				case 'general':
				default:
					flw_su_render_general_tab($client_id, $broker, $registered, $status);
			}
		?>
		</div>
	</div>
	<?php
}