## Secure PDF Embedder (WordPress Plugin)

A lightweight, block-enabled PDF embedder focused on user experience and safety:

- Tracks each reader’s progress and resumes on their last-read page
- Optional mature-content age verification
- Optional members-only UI state
- Optional Stripe-powered paywall with download gate and secure streaming
- Modern Gutenberg block with bulk conversion from legacy shortcode

### Contents
- **Overview**
- **Features**
- **Requirements**
- **Installation**
- **Usage**
  - Block (Gutenberg)
  - Shortcode
- **Settings**
- **Paywall and Stripe**
- **Age Verification (Mature Content)**
- **Progress Tracking**
- **Bulk Tools (Shortcode → Block)**
- **Development**
- **Changelog**

### Overview
Secure PDF Embedder lets you embed PDFs with a great reader experience, while giving you controls to gate, style, and monetize access. Assets are only enqueued when the block or shortcode is present on a singular post/page.

### Features
- **Gutenberg block** `flw/secure-pdf` with dynamic server-side render (reuses shortcode output)
- **Reader UX**: progress save/restore; scrolling stays inside the viewer
- **Optional controls**: Download and Print buttons
- **Optional access**: Members-only UI state (UI messaging/buttons)
- **Mature content**: age gate overlay; verification persists per-URL
- **Paywall**: stripe modal, PaymentIntent creation, purchase marking, gated download with secure one-time stream
- **Styling controls**: global button/footer/viewer colors with transparency and opacity
- **Bulk conversion**: one-click convert existing `[secure_pdf]` shortcodes to the block

### Requirements
- WordPress with the Block Editor enabled
- Companion plugin: `flwsecureupdates` (required by the plugin header)
- For paywall: Stripe publishable and secret keys configured (details below)

### Installation
1. Upload the plugin directory to `wp-content/plugins/` (or install via your preferred flow).
2. Ensure the companion plugin `flwsecureupdates` is installed and active.
3. Activate “Secure PDF Embedder”.

### Usage
#### Block (recommended)
In the editor, add the block named “Secure PDF”. Paste your PDF URL and adjust options (Download, Print, Members Only, Mature Content, Paywall, Cover).

Attributes supported by the block/shortcode:
- `url` (string): PDF URL
- `width` (string): container width (default `100%`)
- `height` (string): container height (default `600px`; include units)
- `show_download` ("true"|"false")
- `show_print` ("true"|"false")
- `members_only` ("true"|"false")
- `mature_content` ("true"|"false")
- `cover_image` (string): optional cover image URL for an overlay
- `open_button_text` (string): text for the cover overlay button (or uses global setting)
- `cover_fit` ("cover"|"fit_width"|"fit_height")
- `requires_purchase` ("true"|"false"): enable paywall
- `price` (string): user-facing price (e.g., `$10.00`); converted to cents internally

#### Shortcode
The block is preferred, but the legacy shortcode remains supported.

```text
[secure_pdf 
  url="https://example.com/file.pdf"
  width="100%" 
  height="600px" 
  show_download="true"
  show_print="true"
  members_only="false"
  mature_content="false"
  cover_image=""
  open_button_text="Open Document"
  cover_fit="cover"
  requires_purchase="false"
  price="$10.00"
]
```

Notes:
- Height must include units (e.g., `600px`).
- Boolean-like attributes use the strings `"true"` or `"false"`.

### Settings
Admin path: `Plugins → FrostLine Works → Secure PDF Embedder` or `?page=securepdf`.

- **Style Options**: configure global colors, transparency, and opacity for:
  - Button background, hover, and text
  - Footer background and top border (thickness, style, color)
  - Viewer outline/border
  - Join button colors
  - Open button colors for the cover overlay
- **Texts/Links**:
  - Download button text
  - Join Now URL and text
  - Open button text (used by the cover overlay if block attribute is empty)

### Paywall and Stripe
When `requires_purchase="true"`:
- A Stripe modal (Elements) collects payment.
- The plugin creates a PaymentIntent via WordPress AJAX, using a server-side secret key.
- On success, the purchase is marked for the logged-in user and the viewer unlocks.
- Download and print buttons are shown after purchase.
- The “download” button routes through a gated endpoint that ensures login and ownership, then issues a short-lived token and streams the file without exposing its true URL.

Stripe keys detection:
- The plugin attempts to retrieve Stripe publishable/secret keys from several sources in this order:
  - Helper functions/options provided by companion/related FLW plugins
  - Site-local options (test/live)
  - Plugin fallback option `secure_pdf_stripe_publishable_key` (publishable key)

If no secret key is configured, the PaymentIntent creation endpoint will reject the request.

### Age Verification (Mature Content)
If `mature_content="true"`, viewers see a DOB prompt. On successful verification (18+), the choice is remembered per-URL in the browser and the viewer unlocks. The overlay also supports being chained after a cover overlay.

### Progress Tracking
- While viewing, the plugin saves the page currently in view via AJAX.
- When re-opened, the viewer scrolls inside the PDF container to the last-read page.
- Progress save/retrieve requires a logged-in user.

### Members Only UI
If `members_only="true"`, non-members see a “Join Now” call-to-action in the footer. Members are considered users with the `patreon_member` role or `administrator`.

### Bulk Tools (Shortcode → Block)
Location: `?page=securepdf&tab=settings` under “Bulk Tools”.

- One-click conversion scans public post types and replaces `[secure_pdf]` shortcodes with the `Secure PDF` block.
- Uses robust block parsing when available; falls back to a regex approach for older WordPress versions.
- A summary of scanned/converted posts is displayed after completion.

### Development
Repo layout (key files):
- `securepdf.php` — main plugin file; hooks, block registration, AJAX, rendering
- `secure-pdf.js` — frontend logic (viewer, progress, mature gate, paywall)
- `secure-pdf.css` — frontend styles (viewer, overlays, footer)
- `block.js` — Gutenberg block definition (no build step; plain JS)
- `block.css` — minimal editor styles
- `assets/` — images used in plugin listings/UI

Notes:
- Frontend scripts/styles are only enqueued on singular posts/pages when the block or shortcode is present.
- `pdf.js` is loaded from a CDN and worker configured at runtime.

### Changelog
See `changelog.txt` for detailed release notes.


