# Remote Uploader for WordPress

Upload WordPress media files directly to a remote FTP/SFTP server (like a download host) while preserving Elementor paths and styles. This plugin ensures that media files (e.g., images) are uploaded to a secondary domain (e.g., `https://dl.example.com/uploads`) while keeping Elementor-generated CSS and assets untouched.

## 🔧 Features

- ✅ Automatically uploads new media to a remote FTP or SFTP server.
- ✅ Keeps Elementor styles (`elementor/css/...`) working by excluding them.
- ✅ Updates media URLs to point to the remote download host.
- ✅ Automatically creates directory structures on the remote server.
- ✅ Deletes the local copy after successful upload to save space.
- ✅ Cleanly integrated into WordPress's `upload_dir` and `wp_handle_upload` hooks.
- ✅ Configurable via a WordPress Settings page.

## 📂 Directory Structure

Your WordPress media files (e.g., `/wp-content/uploads/2025/07/image.jpg`) will be served from:

```
https://dl.example.com/uploads/2025/07/image.jpg
```

But Elementor-generated files (like `/uploads/elementor/css/post-xxxx.css`) remain untouched and are loaded from the main site:

```
https://example.com/wp-content/uploads/elementor/css/post-xxxx.css
```

## 🚀 Installation

1. Upload the plugin folder to your WordPress site's `/wp-content/plugins/` directory.
2. Activate the plugin via the **Plugins** menu in WordPress.
3. Configure the plugin under **Settings → Remote Uploader**.

## ⚙️ Settings UI

Go to **Settings → Remote Uploader** to configure:

- Download Host URL (e.g., `https://dl.example.com/uploads`)
- Protocol: FTP or SFTP
- Port: 21 for FTP, 22 for SFTP (customizable)
- Host
- Username
- Password
- Base Directory (path to the `uploads` root on the remote host)

Changes are applied immediately to new uploads.

## 🛠 Configuration

By default, the plugin uses the values set in the Settings UI. You can optionally define constants in `wp-config.php` to override the UI values (useful for version-controlled or multi-environment setups):

```php
define('REMOTEUPLOADER_SUBDOMAIN_URL', 'https://dl.example.com/uploads');
define('REMOTEUPLOADER_PROTOCOL', 'sftp'); // 'ftp' or 'sftp'
define('REMOTEUPLOADER_PORT', 22);
define('REMOTEUPLOADER_FTP_HOST', 'example.com');
define('REMOTEUPLOADER_FTP_USERNAME', 'username');
define('REMOTEUPLOADER_FTP_PASSWORD', 'password');
define('REMOTEUPLOADER_FTP_BASEDIR', '/domains/example.com/public_html/uploads');
````

If these constants are defined, they take precedence over the Settings UI and a notice will appear on the settings page.

Replace `example.com` with your actual domain.

## ✅ Upload Behavior

* Files uploaded under `/uploads/20xx/` are moved to the remote server.
* Elementor-related uploads (containing `elementor` in path) are **excluded**.
* Files are removed from the local server after successful transfer.

## 🔒 Requirements for SFTP

* PHP extension `ext-ssh2` must be installed and enabled on your server to use SFTP. If it is missing, the plugin will log an error and skip the remote transfer.

## 🔒 Security Note

Make sure your credentials are kept secure. Prefer storing them in `wp-config.php` constants for locked-down environments, or use the Settings UI on single-site installs with trusted admins.

## 📄 License

MIT License

## 👨‍💻 Authors

* **Tyson Brooks**

---

Happy uploading 🚀
